﻿namespace Microsoft.Samples.PlanMyNight.AddIns.PrintItinerary.Controllers
{
    using System.ComponentModel.Composition;
    using System.Linq;
    using System.Web.Mvc;
    using Microsoft.Samples.PlanMyNight.Data;
    using Microsoft.Samples.PlanMyNight.Entities;
    using Microsoft.Samples.PlanMyNight.Infrastructure;

    [Export("PrintItinerary", typeof(IController))]
    [PartCreationPolicy(CreationPolicy.NonShared)]
    [OutputCache(NoStore = true, Duration = 0, VaryByParam = "*")]
    public class PrintItineraryController : Controller
    {
        private readonly IItineraryContainer itineraryContainer;

        private readonly IItinerariesRepository itinerariesRepository;

        private readonly IActivitiesRepository activitiesRepository;

        [ImportingConstructor]
        public PrintItineraryController(IServiceFactory serviceFactory) :
            this(
                serviceFactory.GetItineraryContainerInstance(),
                serviceFactory.GetItinerariesRepositoryInstance(),
                serviceFactory.GetActivitiesRepositoryInstance())
        {
        }

        public PrintItineraryController(IItineraryContainer itineraryContainer, IItinerariesRepository itinerariesRepository, IActivitiesRepository activitiesRepository)
        {
            this.itineraryContainer = itineraryContainer;
            this.itinerariesRepository = itinerariesRepository;
            this.activitiesRepository = activitiesRepository;
        }

        [OutputCache(NoStore = true, Duration = 0, VaryByParam = "*")]
        public ActionResult Print(long? id)
        {
            Itinerary itinerary = null;
            if (id.HasValue)
            {
                itinerary = this.itinerariesRepository.Retrieve(id.Value);
                if (itinerary != null && !itinerary.IsPublic && itinerary.UserId != this.User.UserId())
                {
                    itinerary = null;
                }
            }
            else
            {
                itinerary = this.itineraryContainer.GetCurrent();
            }

            if (itinerary != null && itinerary.Activities.Count > 0)
            {
                Itinerary printItinerary = new Itinerary
                {
                    Created = itinerary.Created,
                    Name = itinerary.Name
                };

                printItinerary.Activities.AddRange(itinerary.Activities.OrderBy(a => a.Order).ToArray());
                this.activitiesRepository.PopulateItineraryActivities(printItinerary);

                return View("Print", printItinerary);
            }

            return new EmptyResult();
        }
    }
}